#include <stdio.h>

#define VERSION "V1.10"
#define HEADINGS 28
#define DESCSIZE 34020

#define MAXVERSIONS 2
#define LASTITEM 0x007d
#define MAXSUBDATA 3

struct offsets
{
        char    *name;
        char    *itemname;
        long    checksize;
        long    descripts;
};

struct offsets offsets[] = {
       "V1.13d",
       "edt/inv.edt",
       1571217,
       0x16dfbf,

       "V1.13z",
       "edt/inv.edt",
       1575325,
       0x16efcb,
};

struct attribtype
{
        long    offset;
        long    start;
        long    end;
        long    size;
        char    *name;
};

struct attribtype attribtype[] = {
       0x16b1b2,0x0000,0x007d,0x0010,"All Items",
       0x16b18a,0x0001,0x0014,0x0002,"Sounds",
       0x16ab46,0x0001,0x0014,0x0008,"Weapons",

       0x16c1be,0x0000,0x007d,0x0010,"All Items",
       0x16c196,0x0001,0x0014,0x0002,"Sounds",
       0x16bb52,0x0001,0x0014,0x0008,"Weapons",
};


struct attriblist
{
        short   offset;
        char    size;
        char    *name;
};

struct attriblist attriblist[0][17] = {
        0x0000,1,"Unknown",
        0x0001,1,"Unknown",
	0x0002,1,"Graphic",
	0x0003,1,"Clip Size",
	0x0004,1,"Unknown",
	0x0005,1,"Unknown",
	0x0006,1,"Unknown",
	0x0007,1,"Unknown",
	0x0008,1,"Unknown",
	0x0009,1,"Range",
	0x000a,1,"Unknown",
	0x000b,1,"Unknown",
	0x000c,-2,"Price",
	0x000e,1,"Unknown",
	0x000f,1,"Unknown",
	0x0000,0,"",
	0x0000,0,"",

        0x0000,1,"Sound FX",
        0x0001,1,"Volume",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",

        0x0000,1,"Breath",
        0x0001,1,"Ammo Type",
	0x0002,1,"Draw Cost",
	0x0003,1,"Fire Rate",
	0x0004,1,"Velocity",
	0x0005,1,"Damage",
	0x0006,1,"Unknown",
	0x0007,1,"Unknown",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
	0x0000,0,"",
};


unsigned char	*buffer;
unsigned char	*descbuffer;

char    dbuffer[1024];
long    ver;


main(int argc,char *argv[])
{
        extern  unsigned char	*buffer;
        long	buffpoint;
	long	buffsize;
	FILE	*exefile;
	FILE	*descfile;
	FILE	*textfile;
	long	c,c1,c2;
        long	temp,temp2,temp3;
        char     ctemp;
        char     *ptemp;
        char     stemp[256];

	printf("\nDeadly Games Weapon Editor %s\n\n",VERSION);

        if(argc < 4){
help:
		printf("\nUsage: dgwedit <executable> <textfile> <[make]|[patch]>\n\n");
		printf("Use the MAKE option to dump stats to a tab delimited text file.\n");
		printf("To apply the changes from the textfile, use the PATCH option.\n");
		return(0);
	}


        if(!(exefile = fopen(argv[1],"rb"))){
		printf("Can't open %s!\n",argv[1]);
		goto help;
	}
	fseek(exefile,0,SEEK_END);
	buffsize = ftell(exefile);
        for(ver = 0 ; ver < MAXVERSIONS ; ver++){
                if(offsets[ver].checksize == buffsize){
                       printf("%s version of executable detected\n",offsets[ver].name);
                       break;
                }
        }
	fseek(exefile,0,SEEK_SET);
        if(ver >= MAXVERSIONS){
        	printf("Unrecognized version of executable.\n");
		fclose(exefile);
		return(1);
	}
	buffer = (char *) malloc(buffsize);
	if(!buffer){
		printf("Unable to allocate %d bytes.\n",buffsize);
		fclose(exefile);
		return(1);
	}

        printf("\nReading binary data...");

	c = fread(buffer,1,buffsize,exefile);
	if (c != buffsize){
		printf("Error while reading executable (Read %d of %d bytes).\n",c,buffsize);
		fclose(exefile);
		return(1);
	}
	fclose(exefile);

	if(!stricmp(argv[3],"make")){
                printf("\nReading item descriptions...");

                if(!(descfile = fopen(offsets[ver].itemname,"rb"))){
                        printf("Error reading item descriptions.\nYou must have the %s file installed.\n",offsets[ver].itemname);
                        return(1);
                }
                descbuffer = (char *) malloc(DESCSIZE);
	        if(!descbuffer){
                        printf("Unable to allocate %d bytes.\n",DESCSIZE);
		        fclose(descfile);
		        return(1);
                }
                c = fread(descbuffer,1,DESCSIZE,descfile);
	        if (c != DESCSIZE){
                        printf("Error while reading item descriptions (Read %d of %d bytes).\n",c,DESCSIZE);
		        fclose(descfile);
		        return(1);
                }
	        fclose(descfile);

                printf("\nDumping weapon stats...");
		if(!(textfile = fopen(argv[2],"w"))){
			printf("Unable to create %s!\n",argv[2]);
			fclose(textfile);
			return(1);
		}

		fprintf(textfile,"Offset\tName\tDescription\tMickey Name");

                for(c = 0 ; c < MAXSUBDATA ; c++){
                        for(c1 = 0 ; ; c1++){
                               if(!attriblist[c][c1].size) break;
                               fprintf(textfile,"\t%s",attriblist[c][c1].name);
                        }
                }

		for(c = 0 ; c <= LASTITEM ; c++){
			fprintf(textfile,"\nItem %d\t",c);
		        for(c1 = 0 ; ; c1 ++){
                                ctemp = *(descbuffer + (c * 0x010e) + c1);
                                if(ctemp > 0x20) ctemp--;
                                if(ctemp) fputc(ctemp,textfile);
                                else break;
                        }
                        fprintf(textfile,"\t");
		        for(c1 = 0 ; ; c1 ++){
                                ctemp = *(descbuffer + (c * 0x010e) + c1 + 0x1e);
                                if(ctemp > 0x20) ctemp--;
                                if(ctemp) fputc(ctemp,textfile);
                                else break;
                        }
                        fprintf(textfile,"\t");
		        for(c1 = 0 ; ; c1 ++){
                                ctemp = *(buffer + (c * 0x11) + c1 + offsets[ver].descripts);
                                if(ctemp) fputc(ctemp,textfile);
                                else break;
                        }

                        for(c1 = 0 ; c1 < MAXSUBDATA ; c1++){
                                for(c2 = 0 ; ; c2++){
                                        if(!attriblist[c1][c2].size) break;
                                        if(c < attribtype[c1 + ver * MAXSUBDATA].start || c > attribtype[c1 + ver * MAXSUBDATA].end){
                                             fprintf(textfile,"\tn/a");
                                        }
				        else{
                                             ptemp = (buffer + attribtype[c1 + ver * MAXSUBDATA].offset + ((c - attribtype[c1 + ver * MAXSUBDATA].start) * attribtype[c1 + ver * MAXSUBDATA].size) + attriblist[c1][c2].offset);
                                             switch (attriblist[c1][c2].size){
                                                    case 1:
                                                         fprintf(textfile,"\t%d",*(unsigned char*) (ptemp));
                                                         break;
                                                    case -1:
                                                         fprintf(textfile,"\t%d",*(signed char*) (ptemp));
                                                         break;
                                                    case 2:
                                                         fprintf(textfile,"\t%d",*(unsigned short*) (ptemp));
                                                         break;
                                                    case -2:
                                                         fprintf(textfile,"\t%d",*(signed short*) (ptemp));
                                                         break;
                                             }
                                        }
                                }
                        }
                }

                printf("\nDone!\n");
                fclose(textfile);
		return(0);
	}

	if(stricmp(argv[3],"patch")){
		printf("\nInvalid option.  Use either MAKE or PATCH\n");
		goto help;
	}

        printf("\nReading item descriptions...");

        if(!(descfile = fopen(offsets[ver].itemname,"rb"))){
                printf("Error reading item descriptions.\nYou must have the %s file installed.\n",offsets[ver].itemname);
                return(1);
        }
        descbuffer = (char *) malloc(DESCSIZE);
	if(!descbuffer){
                printf("Unable to allocate %d bytes.\n",DESCSIZE);
	        fclose(descfile);
	        return(1);
        }
        c = fread(descbuffer,1,DESCSIZE,descfile);
	if (c != DESCSIZE){
                printf("Error while reading item descriptions (Read %d of %d bytes).\n",c,DESCSIZE);
                fclose(descfile);
	        return(1);
        }
        fclose(descfile);

	if(!(textfile = fopen(argv[2],"r"))){
        	printf("Unable to read %s!\n",argv[2]);
		fclose(textfile);
		return(1);
        }

        printf("\nConverting text file...");

        temp = 0;
        for(;;){
                ctemp = fgetc(textfile);
                if(ctemp == '\t') temp++;
                if(ctemp == '\n') break;
                if(feof(textfile) || ferror(textfile)){
			printf("Error while parsing headings!\n");
			fclose(textfile);
			return(1);
                }
	}

        if(temp != HEADINGS){
		printf("Error while parsing!  (%d Headings)\n",temp);
		printf("If you are using a textfile from an older version, you\n");
                printf("use MAKE to create a new textfile.  See documentation.\n");
		fclose(textfile);
		return(1);
        }

	for(;;){
                for(c1 = 0 ; c1 < 255 ; c1++){
ignorejunk:
                       stemp[c1] = getc(textfile);
                       if(feof(textfile)) goto exit;
                       /* Ignore junk Tabs/Spaces/Whatever at the ends of lines */
                       if(!c1){
                               if(stemp[0] < 'a' || stemp[0] > 'z'){
                                      if(stemp[0] < 'A' || stemp[0] > 'Z') goto ignorejunk;
                               }
                       }
                       if(stemp[c1] == ' '){
                               stemp[c1]=0;
                               break;
                       }
                }

                if(stricmp("Item",stemp)){
			printf("Error while parsing! (%s)\n",stemp);
			fclose(textfile);
			return(1);
                }

                fscanf(textfile,"%d",&temp);

                ctemp = getc(textfile);
                for(c1 = 0 ; ; c1 ++){
                        ctemp = getc(textfile);
                        if(ctemp == 0x22) ctemp = getc(textfile);
                        if(ctemp == '\t') ctemp = 0;
                        if(ctemp > 0x20) ctemp++;
                        *(descbuffer + (temp * 0x010e) + c1) = ctemp;
                        if(!ctemp) break;
                }
                for(c1 = 0 ; ; c1 ++){
                        ctemp = getc(textfile);
                        if(ctemp == 0x22) ctemp = getc(textfile);
                        if(ctemp == '\t') ctemp = 0;
                        if(ctemp > 0x20) ctemp++;
                        *(descbuffer + (temp * 0x010e) + c1 + 0x1e) = ctemp;
                        if(!ctemp) break;
                }
                for(c1 = 0 ; ; c1 ++){
                        ctemp = getc(textfile);
                        if(ctemp == 0x22) ctemp = getc(textfile);
                        if(ctemp == '\t') ctemp = 0;
                        if(!ctemp) break;
                        if(c1 < 0x10) *(buffer + (temp * 0x11) + c1 + offsets[ver].descripts) = ctemp;
                }
                for( ; c1 < 0x10 ; c1++){
                        *(buffer + (temp * 0x11) + c1 + offsets[ver].descripts) = ' ';
                }
                *(buffer + (temp * 0x11) + 0x10 + offsets[ver].descripts) = 0;

                for(c1 = 0 ; c1 < MAXSUBDATA ; c1++){
                        for(c2 = 0 ; ; c2++){
                               if(!attriblist[c1][c2].size) break;
                               if(temp < attribtype[c1 + ver * MAXSUBDATA].start || temp > attribtype[c1 + ver * MAXSUBDATA].end){
                                    fscanf(textfile,"%*s");
                               }
                               else{
                                    ptemp = (buffer + attribtype[c1 + ver * MAXSUBDATA].offset + ((temp - attribtype[c1 + ver * MAXSUBDATA].start) * attribtype[c1 + ver * MAXSUBDATA].size) + attriblist[c1][c2].offset);
                                    fscanf(textfile,"%d",&temp2);
                                    switch (attriblist[c1][c2].size){
                                           case 1:
                                                *(unsigned char*) ptemp = temp2;
                                                break;
                                           case -1:
                                                *(signed char*) ptemp = temp2;
                                                break;
                                           case 2:
                                                *(unsigned short*) ptemp = temp2;
                                                break;
                                           case -2:
                                                *(signed short*) ptemp = temp2;
                                                break;
                                    }
                               }
                        }
                }

                ctemp = getc(textfile);
        }

exit:
        printf("\nSaving descriptions...");
        if(!(descfile = fopen(offsets[ver].itemname,"wb"))){
                printf("Error writing item descriptions.\n");
                return(1);
        }
        c = fwrite(descbuffer,1,DESCSIZE,descfile);
	if (c != DESCSIZE){
                printf("Error while writting item descriptions (Wrote %d of %d bytes).\n",c,DESCSIZE);
                fclose(descfile);
	        return(1);
        }
        fclose(descfile);


        fclose(textfile);
        if(!(exefile = fopen(argv[1],"wb"))){
		printf("Error writing %s!\n",argv[1]);
		fclose(exefile);
		return(1);
	}
        printf("\nSaving binary data...");
        fwrite(buffer,1,buffsize,exefile);
	if(ferror(exefile)){
		printf("Error writing %s!\n",argv[1]);
		fclose(exefile);
		return(1);
	}
        fclose(exefile);
        printf("\nDone!\n");
	return(0);
}

